<?php
/**
 * OnlyPropertyImageCollectionBuilder.php 2020-3-30
 * Gambio GmbH
 * http://www.gambio.de
 * Copyright (c) 2020 Gambio GmbH
 * Released under the GNU General Public License (Version 2)
 * [http://www.gnu.org/licenses/gpl-2.0.html]
 */

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Images\Builders;

use Gambio\Shop\SellingUnit\Images\Entities\Interfaces\SellingUnitImageCollectionInterface;
use Gambio\Shop\SellingUnit\Images\Entities\SellingUnitOnlyPropertyImageCollection;

/**
 * Class OnlyPropertyImageCollectionBuilder
 * @package Gambio\Shop\SellingUnit\Images\Builders
 */
class OnlyPropertyImageCollectionBuilder extends CollectionBuilder
{
    /**
     * @inheritDoc
     */
    public function build() : SellingUnitImageCollectionInterface
    {
        $result       = new SellingUnitOnlyPropertyImageCollection($this->images);
        $this->images = [];
        return $result;
    }
}